import os
import subprocess
from http.server import BaseHTTPRequestHandler, HTTPServer
import urllib.parse

prefix = "/run/media/tristan/Main/music/tidal-dl/Playlist/my_tracklist_10k/"
#prefix = "/dev/shm/songcache/"

class MyHandler(BaseHTTPRequestHandler):
    def do_GET(self):
        print(self.path)

        parsed_url = urllib.parse.urlparse(self.path)

        if parsed_url.path.endswith('.m4a'):
            # Extract file name from path

            filename = urllib.parse.unquote(parsed_url.path[1:]).replace("full/", "").replace("preview/", "").replace("info/", "")
            print("filename: " + filename)

            # Convert the file to .wav using ffmpeg and cut the first 60 seconds
            real_path = parsed_url.path.split("/")

            self.send_response(200)

            if real_path[1] == "preview" or real_path[1] == "full":
                output_filename = '/dev/shm/' + str(len(self.path)) + "_" + filename.split('.')[0].split("/")[-1] + '.wav'
                time_mgr = '-t' if parsed_url.path.split("/")[1] == "preview" else '-ss'
                subprocess.run(['ffmpeg', '-i', prefix+filename, time_mgr, '20', '-y', output_filename], check=True)

                # Open the converted file and read it
                with open(output_filename, 'rb') as f:
                    content = f.read()

                # Send response headers
                self.send_header('Content-type', 'audio/x-wav')

            elif real_path[1] == "info":
                result = subprocess.run(['ffprobe',  '-v', 'quiet', '-print_format', 'json', '-show_format', '-show_streams', prefix+filename], check=True, capture_output=True)
                content = result.stdout

                self.send_header('Content-type', 'application/json')

            self.send_header('Content-Length', len(content))
            self.end_headers()

            # Send the content
            self.wfile.write(content)

            if output_filename:
                os.remove(output_filename)
        else:
            self.send_error(404, 'File Not Found: %s' % self.path)

def run(server_class=HTTPServer, handler_class=MyHandler):
    server_address = ('', 10454)
    httpd = server_class(server_address, handler_class)
    print('Starting httpd...')
    httpd.serve_forever()

if __name__ == '__main__':
    run()
