import os
import sys

import undetected_chromedriver as uc
import expected_conditions as EC


import time

user_email = "noraaz@gwu.edu"
user_password = "ZhZh0808"
product = "224"

# Custom WebDriverWait implementation to replace selenium.webdriver.support.ui.WebDriverWait
class WebDriverWait:
    def __init__(self, driver, timeout, poll_frequency=0.5, ignored_exceptions=None):
        """
        Constructor for MyWebDriverWait

        :param driver: WebDriver instance
        :param timeout: Maximum time to wait in seconds
        :param poll_frequency: How frequently to check for the condition
        :param ignored_exceptions: Exceptions to ignore during polling
        """
        self._driver = driver
        self._timeout = timeout
        self._poll = poll_frequency
        self._ignored_exceptions = ignored_exceptions or []

    def until(self, method, message=''):
        """
        Waits until the given method returns a non-False value.

        :param method: A method that takes a driver as an argument and returns a boolean
        :param message: Optional error message
        :return: The result of the method
        """
        end_time = time.time() + self._timeout
        while True:
            try:
                value = method(self._driver)
                if value:
                    return value
            except tuple(self._ignored_exceptions) as e:
                pass  # Ignore specified exceptions
            except Exception as e:
                if time.time() > end_time:
                    raise e  # Re-raise if timeout expired

            # Check if we've timed out
            if time.time() > end_time:
                raise TimeoutError(message or f"Timed out after {self._timeout} seconds")

            # Wait before trying again
            time.sleep(self._poll)

    def until_not(self, method, message=''):
        """
        Waits until the given method returns a False value.

        :param method: A method that takes a driver as an argument and returns a boolean
        :param message: Optional error message
        :return: The result of the method or True once it returns False
        """
        end_time = time.time() + self._timeout
        while True:
            try:
                value = method(self._driver)
                if not value:
                    return True
            except tuple(self._ignored_exceptions) as e:
                return True  # If we get an expected exception, element is not present
            except Exception as e:
                if time.time() > end_time:
                    raise e  # Re-raise if timeout expired

            # Check if we've timed out
            if time.time() > end_time:
                raise TimeoutError(message or f"Timed out after {self._timeout} seconds")

            # Wait before trying again
            time.sleep(self._poll)

def wait_for_element(driver, by, value, retries=3, timeout=1):
    for i in range(retries):
        try:
            return WebDriverWait(driver, timeout).until(EC.presence_of_element_located((by, value)))
        except Exception as e:
            if i < retries - 1:
                time.sleep(0.5)  # brief pause before retrying
                continue
            else:
                raise e


def accept_policy():
    try:
        accept_button = wait_for_element(driver, By.XPATH, '//div[contains(@class, "policy_acceptBtn__ZNU71") and text()="ACCEPT"]')
        accept_button.click()
        print(f"Accepted policy for product {product}")
    except Exception as e:
        print(f"No policy prompt for product {product}: {e}")

def sign_in():
    signed_in = False
    retry_count = 0
    while not signed_in and retry_count < 3:
        try:
            sign_in_button = wait_for_element(driver, By.XPATH, '//div[contains(@class, "header_infoTitle__Fse4B ") and text()="Sign in / Register"]')
            sign_in_button.click()
            print(f"Clicked Sign in for product {product}")

            email_input = wait_for_element(driver, By.XPATH, '//input[@id="email" and @placeholder="Enter your e-mail address"]')
            email_input.send_keys(user_email)
            print(f"Entered email for product {product}")

            continue_button = wait_for_element(driver, By.XPATH, '//button[@type="button" and contains(@class, "ant-btn-primary") and text()="CONTINUE"]')
            continue_button.click()
            print(f"Clicked Continue for product {product}")

            password_input = wait_for_element(driver, By.XPATH, '//input[@id="password" and @placeholder="Enter your password"]')
            password_input.send_keys(user_password)
            print(f"Entered password for product {product}")

            sign_in_submit_button = wait_for_element(driver, By.XPATH, '//button[@type="submit" and contains(@class, "ant-btn-primary") and text()="SIGN IN"]')
            sign_in_submit_button.click()
            print(f"Clicked Sign in submit for product {product}")
            time.sleep(2)  # Wait for 2 seconds to ensure sign-in completes
            signed_in = True
        except Exception as e:
            print(f"Sign in process failed for product {product}, retrying... ({retry_count+1}/3): {e}")
            retry_count += 1
            driver.get(f'https://www.popmart.com/us/pop-now/set/{product}')
            accept_policy()

    if not signed_in:
        print(f"Failed to sign in for product {product} after 3 attempts.")
        driver.quit()
        return False
    return True


driver = uc.Chrome()
driver.get("https://www.popmart.com/us/pop-now/set/224")
time.sleep(2)

#sign_in()
#time.sleep(2)
#accept_policy()
#time.sleep(2)

#driver.get("https://www.popmart.com/us/pop-now/set/224")
#time.sleep(2)
