# expected_conditions.py
"""
Custom implementation of Selenium's expected_conditions module
"""

import undetected_chromedriver as uc
#from undetected_chromedriver.selenium.common import exceptions

NoSuchElementException = uc.selenium.common.exceptions.NoSuchElementException
StaleElementReferenceException = uc.selenium.common.exceptions.StaleElementReferenceException
TimeoutException = uc.selenium.common.exceptions.TimeoutException

class element_to_be_clickable(object):
    def __init__(self, locator):
        self.locator = locator

    def __call__(self, driver):
        element = driver.find_element(*self.locator)
        if element.is_enabled() and element.is_displayed():
            return element
        return False

class presence_of_element_located(object):
    def __init__(self, locator):
        self.locator = locator

    def __call__(self, driver):
        try:
            return driver.find_element(*self.locator)
        except exceptions.NoSuchElementException:
            return False

class visibility_of_element_located(object):
    def __init__(self, locator):
        self.locator = locator

    def __call__(self, driver):
        try:
            element = driver.find_element(*self.locator)
            return element if element.is_displayed() else False
        except (NoSuchElementException, StaleElementReferenceException):
            return False

class visibility_of(object):
    def __init__(self, element):
        self.element = element

    def __call__(self, driver):
        try:
            return self.element if self.element.is_displayed() else False
        except StaleElementReferenceException:
            return False

class text_to_be_present_in_element(object):
    def __init__(self, locator, text_):
        self.locator = locator
        self.text = text_

    def __call__(self, driver):
        try:
            element = driver.find_element(*self.locator)
            return self.text in element.text
        except (NoSuchElementException, StaleElementReferenceException):
            return False

class presence_of_all_elements_located(object):
    def __init__(self, locator):
        self.locator = locator

    def __call__(self, driver):
        elements = driver.find_elements(*self.locator)
        return elements if elements else False

class title_contains(object):
    def __init__(self, title):
        self.title = title

    def __call__(self, driver):
        return self.title in driver.title

class title_is(object):
    def __init__(self, title):
        self.title = title

    def __call__(self, driver):
        return self.title == driver.title

class url_contains(object):
    def __init__(self, url):
        self.url = url

    def __call__(self, driver):
        return self.url in driver.current_url

class url_to_be(object):
    def __init__(self, url):
        self.url = url

    def __call__(self, driver):
        return self.url == driver.current_url

class element_located_to_be_selected(object):
    def __init__(self, locator):
        self.locator = locator

    def __call__(self, driver):
        try:
            element = driver.find_element(*self.locator)
            return element.is_selected()
        except (NoSuchElementException, StaleElementReferenceException):
            return False
