#ifndef _BIBLIOLC_H_
#define _BIBLIOLC_H_


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct livre {
    int num;
    char *titre;
    char *auteur;
    struct livre *suiv;
} Livre;

typedef struct { /* Tete fictive */
    Livre *L; /* Premier element */
} Biblio;

Livre *creer_livre(int num, char *titre, char *auteur); // Création d'un livre.
void liberer_livre(Livre *l); //Libération de l'espace pris en mémoire par Livre.
Biblio *creer_biblio(); // Création d'une bibliothèque
void liberer_biblio(Biblio *b); //Libération de l'espace pris en mémoire par Biblio.
void
inserer_en_tete(Biblio *b, int num, char *titre, char *auteur);//Ajouter un nouveau livre en tête de notre bibliothèque.
void inserer_en_tete2(Biblio *b,
                      Livre *l); // Ajouter un nouveau livre dans la bibliothèque sans connaitre le titre, numéro et auteur

/*--------------------------------Q-1.6----------------------------*/

void afficher_livre(Livre *L);//Affichage d'un livre
void afficher_biblio(Biblio *b);//Affichage d'une bibliothèque
Livre *recherche_num(Biblio *b, int numero);//Rechercher un livre grâce à son numéro
Livre *recherche_titre(Biblio *b, char *t);//Rechercher un livre grâce à son titre
Biblio *all_livres_auteur(Biblio *b, char *a);//Retourne tous les livres du même auteur dans une nouvelle bibliothèque
void supprimer_livre(Biblio *b, int n, char *t, char *a);//Suppression d'un livre
void fusion(Biblio *b1, Biblio *b2);//On fusionne deux bibliothèques et on supprime la deuxième
Biblio *plusieurs_exemplaires(
        Biblio *b);//Retourne une bibliothèque contenant les livres du même auteur ayant le même titre mais différents numéros



#endif