#!/usr/bin/zsh

DIR="$PWD"

# update firefox
update_firefox () {
    cd ~/Documents/firefox-nightly/mozilla-unified
    export MOZBUILD_STATE_PATH="/home/tristan/Documents/firefox-nightly/mozbuild"
    hg pull --rebase autoland
    hg update
    ./mach build
    cd $DIR
}

# run
run_firefox () {
    /home/tristan/Documents/firefox-nightly/mozilla-unified/obj-x86_64-pc-linux-gnu/dist/bin/firefox-bin -P TristanFirefox -no-remote
}

# update blender
update_blender () {
    cd ~/Documents/blender-git/blender
    make update
    make -j8
    cd $DIR
}

# run
run_blender () {
    /home/tristan/Documents/blender-git/build_linux/bin/blender
}

# update godot
update_godot () {
    cd ~/Documents/godot
    git pull origin master
    scons -j6 platform=linuxbsd tools=yes target=release_debug bits=64
    cd $DIR
}

# run
run_godot () {
    /home/tristan/Documents/godot/bin/godot.linuxbsd.opt.tools.64
}

# update mixxx
update_mixxx () {
    cd ~/Documents/mixxx
    git fetch origin main
    cd build
    cmake ..
    cmake --build -j8 .
    cd $DIR
}

# run
run_mixxx () {
    /home/tristan/Documents/mixxx/build/mixxx
}

#if [ $1 -eq "firefox" ] ; then
#    update_firefox ; fi
#
