#include "biblioLC.h"
#include "entreeSortieLC.h"

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void menu() {
    printf("Veuillez choisir:\n");
    printf("0 : Fin du programme.\n");
    printf("1 : Afficher un livre.\n");
    printf("2 : Afficher la bibliothèque.\n");
    printf("3 : Insérer un livre dans une bibliothèque.\n");
    printf("4 : Rechercher un livre grâce à son numéro. \n");
    printf("5 : Rechercher un livre grâce à son titre. \n");
    printf("6 : Rechercher tous les livres du même auteur. \n");
    printf("7 : Supprimer un livre.\n");
    printf("8 : Fusionner deux bibliothèque.\n");
    printf("9 : Vous souhaitez voir s'il existe plusieurs exemplaires.\n");
}

int main(int argc, char **argv) {


    /*--------------------Conditions-d'exécution-du-main----------------------*/
    if (argc != 3) {
        printf("Erreur, veuillez respecter le format : ./main nomfic nbLigne");
        return 1;
    }

    /*--------------------Q-1.4.-Lecture-du-fichier----------------------*/
    char *fichier = argv[1];
    int nbLignes = atoi(argv[2]);
    Biblio *B = charger_n_entrees(fichier, nbLignes);

    int rep;
    do {
        menu();
        scanf("%d", &rep);
        switch (rep) {

            case 1 :;
                { /*-----Affichage-d'un-livre-----*/
                    printf("Veuillez entrer les coordonnées du livre que vous souhaitez afficher : \n");
                    char titre[256];
                    char auteur[256];
                    int num;
                    scanf(" %d %s %s ", &num, titre, auteur);
                    printf("Affichage du livre : \n");
                    printf("%d  %s  %s  \n", num, titre, auteur);
                }
                break;

            case 2 :;
                {/*-----Affichage-d'une-bibliothèque-----*/
                    printf("Vous désirez voir la bibliothèque. \n");
                    afficher_biblio(B);
                }
                break;

            case 3 :;
                {/*-----Insertion-d'un-livre-----*/
                    int num;
                    char titre[256];
                    char auteur[256];
                    printf("Veuillez entrer les coordonnées du livre que vous souhaitez insérer : \n");
                    if (scanf(" %d %s %s", &num, titre, auteur) == 3) {
                        inserer_en_tete(B, num, titre, auteur);
                        printf("Ajout fait! \n");
                    } else {
                        printf("Erreur format\n");
                    }
                }
                break;

            case 4 :;
                {/*-----Recherche-d'un-ouvrage-par-son-numéro-----*/
                    printf("Vous souhaitez trouver un ouvrage grâce à son numéro.\n");
                    int num;
                    printf("Veuillez entrer le numéro: \n");
                    if (scanf(" %d", &num) == 1) {
                        Livre *l = recherche_num(B, num);
                        afficher_livre(l);
                        liberer_livre(l);
                    } else {
                        printf("Saisi incorrect.\n");
                    }
                }
                break;

            case 5 :;
                {/*-----Recherche-d'un-ouvrage-par-son-titre-----*/
                    printf("Vous souhaitez trouver un ouvrage grâce à son titre. \n");
                    char titre[256];
                    printf("Veuillez entrer le titre: \n");
                    if (scanf("%s", titre) == 1) {
                        Livre *l = recherche_titre(B, titre);
                        afficher_livre(l);
                    } else {
                        printf("Saisi incorrect.\n");
                    }
                }
                break;

            case 6 :;
                {/*-----Recherche-tous-les-ouvrages-d'un-même-auteur-----*/
                    printf("Vous souhaitez trouver tous les ouvrages d'un même auteur.\n");
                    char auteur[256];
                    printf("Veuillez entrer le nom de l'auteur: \n");
                    if (scanf("%s", auteur) == 1) {
                        Biblio *m_a = all_livres_auteur(B, auteur);
                        afficher_biblio(m_a);
                        /* printf ("Voulez-vous enregistrer cette nouvelle bibliothèque ? \n");
                        printf ("Veuillez taper 0 pour oui. \n ");
                        printf ("Veuillez taper 1 pour non. \n");

                        int choix;
                        scanf("%d",&choix);
                            if (choix==0){
                                enregistrer_biblio(m_a,"Livres_même_auteur.txt");
                                liberer_biblio(m_a) ;
                            }*/

                    }
                }
                break;

            case 7 :;
                {/*-----Suppression-d'un-livre-----*/
                    printf("Vous souhaitez supprimer un livre de la biliothèque.\n");
                    printf("Veuillez entrer les coordonnées du livre que vous souhaitez supprimer.\n");
                    int num;
                    char titre[256];
                    char auteur[256];
                    if (scanf(" %d %s %s", &num, titre, auteur) == 3) {
                        supprimer_livre(B, num, titre, auteur);
                        printf("Suppression faite.\n");
                        printf("Souhaitez-vous vérifier la bibliothèque ?\n"
                               "Si oui taper 0.\n"
                               "Si non taper 1. \n");
                        int choix;
                        if (scanf("%d", &choix) == 0) {
                            afficher_biblio(B);
                            liberer_biblio(B);
                        } else {
                            printf("\n");
                        }
                    }
                }
                break;

            case 8 :;
                {/*-----Fusionner-2-bibliothèques-----*/
                    printf("Veuillez entrer le fichier de la bibliotheque 2 et le nombre de lignes à ajouter.\n");
                    int nbL;
                    char Fichier2[256];
                    if (scanf(" %s %d", Fichier2, &nbL) == 2) {
                        Biblio *B2 = charger_n_entrees(Fichier2, nbL);
                        fusion(B, B2);
                        afficher_biblio(B);
                    } else {
                        printf("Erreur de format\n");
                    }
                }
                break;

            case 9 :;
                {/*-----Plusieurs-exemplaires-----*/
                    Biblio *finale = plusieurs_exemplaires(B);
                    afficher_biblio(finale);
                    printf("Voulez vous enregistrer la bibliotheque?\n"
                           "Entrer 0 pour oui.\n"
                           "Entrer 1 pour non.\n");
                    int nb;
                    scanf(" %d", &nb);
                    if (nb == 0) { enregistrer_biblio(finale, "Livres_diff_exemplaires.txt"); }
                    liberer_biblio(finale);
                }
                break;

        }
    } while (rep != 0);

    liberer_biblio(B);
    printf("Fin du programme, au revoir !\n");
    return 0;
}


