#include "entreeSortieH.h"

#include "biblioH.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


BiblioH *charger_n_entrees(char *nomfic, int n, int m) {
    FILE *fic = fopen(nomfic, "r"); //on utilise r pour read
    BiblioH *b = creer_biblio(m);// on crée une bibliothèque
    char ligne[256]; // fait référence à la fin d'une ligne, ou retour à la ligne
    int i = 0;
    int num;
    char titre[256];
    char auteur[256];

    // Cas où le fichier est vide ou inexistant
    if (fic == NULL) {
        printf("Problème d'ouverture du fichier.\n");
        exit(1);
    } else {
        while ((fgets(ligne, 256, fic) != NULL) && (i <= n)) { //lis les lignes jusqu'à n
            if (sscanf(ligne, "%d  %s  %s", &num, titre, auteur) == 3) {
                inserer(b, num, titre, auteur);
            } else {
                printf("Format incorrect.\n");
                exit(1);
            }
            i++;
        }
    }
    fclose(fic); //fermeture du fichier
    return b;
}


void enregistrer_biblio(BiblioH *b, char *nomfic) {
    FILE *fic = fopen(nomfic, "w"); //on utilise w pour write
    int i = 0;
    LivreH *L = b->T[i];

    // Cas où le fichier est vide ou inexistant
    if (fic == NULL) {
        printf("Problème d'ouverture du fichier. \n");
    } else {
        while (L->suiv != NULL) {
            fprintf(fic, " %d %s %s \n", L->num, L->titre, L->auteur);
            L = L->suiv;
        }
    }
    fclose(fic); //fermeture du fichier
}
