import subprocess


def _test_command(parameters):
    command = "python find_overlaps.py " + parameters
    output = subprocess.check_output(command, universal_newlines=True)
    assert output == expected


def test_find_overlaps():
    _test_command("37.419714, -122.083275 37.420626, -122.085045")
    _test_command("37.419714, -122.085045 37.420626, -122.083275")
    _test_command("37.420626, -122.083275 37.419714, -122.085045")
    _test_command("37.420626, -122.085045 37.419714, -122.083275")


expected = """LatLonBox(north=37.420626, south=37.419714, west=-122.085045, east=-122.083275)
[Octant level 1]
2
[Octant level 2]
20
[Octant level 3]
205
[Octant level 4]
2052
[Octant level 5]
20527
[Octant level 6]
205270
[Octant level 7]
2052706
[Octant level 8]
20527061
[Octant level 9]
205270616
[Octant level 10]
2052706160
[Octant level 11]
20527061605
[Octant level 12]
205270616052
[Octant level 13]
2052706160527
[Octant level 14]
20527061605273
[Octant level 15]
205270616052735
[Octant level 16]
2052706160527351
[Octant level 17]
20527061605273514
[Octant level 18]
205270616052735141
205270616052735140
[Octant level 19]
2052706160527351416
2052706160527351417
2052706160527351415
2052706160527351414
2052706160527351405
2052706160527351407
2052706160527351406
2052706160527351404
[Octant level 20]
20527061605273514162
20527061605273514160
20527061605273514161
20527061605273514163
20527061605273514172
20527061605273514170
20527061605273514152
20527061605273514150
20527061605273514141
20527061605273514143
20527061605273514142
20527061605273514140
20527061605273514051
20527061605273514050
20527061605273514052
20527061605273514053
20527061605273514071
20527061605273514073
20527061605273514072
20527061605273514070
20527061605273514061
20527061605273514063
20527061605273514043
20527061605273514041
20527061605273514166
20527061605273514164
20527061605273514165
20527061605273514167
20527061605273514176
20527061605273514174
20527061605273514156
20527061605273514154
20527061605273514145
20527061605273514147
20527061605273514146
20527061605273514144
20527061605273514055
20527061605273514054
20527061605273514056
20527061605273514057
20527061605273514075
20527061605273514077
20527061605273514076
20527061605273514074
20527061605273514065
20527061605273514067
20527061605273514047
20527061605273514045
"""
