# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

import time
from math import sqrt

class Timer():
    def __init__(self):
        self.start = time.perf_counter()

    def ellapsed(self):
        return time.perf_counter() - self.start

class Counter():
    def __init__(self):
        self.reset()

    def average(self):
        if self.sample_count == 0:
            return 0
        else:
            return self.accumulated / self.sample_count

    def stddev(self):
        if self.sample_count == 0:
            return 0
        else:
            avg = self.average()
            var = self.accumulated_sq / self.sample_count - avg * avg
            return sqrt(max(0, var))

    def add_sample(self, value):
        self.sample_count += 1
        self.accumulated += value
        self.accumulated_sq += value * value

    def reset(self):
        self.sample_count = 0
        self.accumulated = 0.0
        self.accumulated_sq = 0.0

class Stats():
    def __init__(self):
        self.counters = {}

    def add_sample(self, name, value):
        if name not in self.counters:
            self.counters[name] = Counter()
        self.counters[name].add_sample(value)

    def print(self):
        print("Statistics:")
        for k, v in self.counters.items():
            print(f" - {k}: {v.average()*1000.:.03}ms (±{v.stddev()*1000.:.03}ms, {v.sample_count} samples, total={v.accumulated})")
